OutFile "Budget.exe"

; Include Modern UI
!include "MUI2.nsh"

Name "Budget Planner"

; Define the directory for installer data
!define APP_DIST_PATH "dist"

InstallDir "$LOCALAPPDATA\BudgetPlanner"
InstallDirRegKey HKCU "Software\BudgetPlanner" "InstallPath"
RequestExecutionLevel user

!define MUI_ICON "resources\icons\budget.ico"
!define MUI_UNICON "resources\icons\budget.ico"

; Add installation pages
!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH

!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_LANGUAGE "English"

Section "Install"
    SetOutPath "$INSTDIR"
    
    ; Copy all files from distribution folder
    File /r "${APP_DIST_PATH}\*.*"
    
    ; Create shortcuts
    CreateDirectory "$SMPROGRAMS\Budget Planner"
    CreateShortcut "$SMPROGRAMS\Budget Planner\Budget Planner.lnk" "$INSTDIR\Budget.exe" "" "$INSTDIR\resources\icons\budget.ico"
    CreateShortcut "$DESKTOP\Budget Planner.lnk" "$INSTDIR\Budget.exe" "" "$INSTDIR\resources\icons\budget.ico"
    
    ; Create uninstaller
    WriteUninstaller "$INSTDIR\Uninstall.exe"
    
    ; Registry entries (only HKCU)
    WriteRegStr HKCU "Software\BudgetPlanner" "InstallPath" "$INSTDIR"
    WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\BudgetPlanner" "DisplayName" "Budget Planner"
    WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\BudgetPlanner" "UninstallString" "$INSTDIR\Uninstall.exe"
    WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\BudgetPlanner" "DisplayIcon" "$INSTDIR\resources\icons\budget.ico"
SectionEnd

Section "Uninstall"
    Delete "$INSTDIR\Budget.exe"
    Delete "$INSTDIR\*.dll"
    RMDir /r "$INSTDIR\resources"
    Delete "$INSTDIR\*.*"
    Delete "$INSTDIR\Uninstall.exe"
    RMDir "$INSTDIR"
    
    Delete "$SMPROGRAMS\Budget Planner\Budget Planner.lnk"
    RMDir "$SMPROGRAMS\Budget Planner"
    Delete "$DESKTOP\Budget Planner.lnk"
    
    DeleteRegKey HKCU "Software\BudgetPlanner"
    DeleteRegKey HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\BudgetPlanner"
SectionEnd