!include "MUI2.nsh"

Name "Earnings Potential Calculator"
OutFile "earnings.exe"
!define APP_DIST_PATH "dist"
InstallDir "$LOCALAPPDATA\Earnings"
RequestExecutionLevel user

!define MUI_ICON "resources\icons\earnings.ico"
!define MUI_UNICON "resources\icons\earnings.ico"

!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_LANGUAGE "English"

Section "Install"
    SetOutPath "$INSTDIR"
    File /r "${APP_DIST_PATH}\*.*"
    
    # Rename the executable
    Rename "$INSTDIR\earnings-win_x64.exe" "$INSTDIR\Earnings.exe"
    
    CreateDirectory "$SMPROGRAMS\Earnings Potential Calculator"
    CreateShortCut "$SMPROGRAMS\Earnings Potential Calculator\Earnings Potential Calculator.lnk" "$INSTDIR\Earnings.exe"
    CreateShortCut "$DESKTOP\Earnings Potential Calculator.lnk" "$INSTDIR\Earnings.exe"
    
    WriteUninstaller "$INSTDIR\Uninstall.exe"
    
    WriteRegStr HKCU "Software\EarningsPotentialCalculator" "InstallPath" "$INSTDIR"
    WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\EarningsPotentialCalculator" "DisplayName" "Earnings Potential Calculator"
    WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\EarningsPotentialCalculator" "UninstallString" "$INSTDIR\Uninstall.exe"
    WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\EarningsPotentialCalculator" "DisplayIcon" "$INSTDIR\Earnings.exe"
SectionEnd

Section "Uninstall"
    Delete "$INSTDIR\Earnings.exe"
    Delete "$INSTDIR\*.dll"
    RMDir /r "$INSTDIR\resources"
    Delete "$INSTDIR\*.*"
    Delete "$INSTDIR\Uninstall.exe"
    RMDir "$INSTDIR"
    
    Delete "$SMPROGRAMS\Earnings Potential Calculator\Earnings Potential Calculator.lnk"
    RMDir "$SMPROGRAMS\Earnings Potential Calculator"
    Delete "$DESKTOP\Earnings Potential Calculator.lnk"
    
    DeleteRegKey HKCU "Software\EarningsPotentialCalculator"
    DeleteRegKey HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\EarningsPotentialCalculator"
SectionEnd

