#!/bin/bash


APP_NAME="earnings"
INSTALL_DIR="/opt/$APP_NAME"
DESKTOP_ENTRY="/usr/share/applications/$APP_NAME.desktop"


# Ensure the script is run with sudo or root permissions
if [ "$EUID" -ne 0 ]; then
 echo "Please run as root or use sudo"
 exit 1
fi


# Remove the application files
if [ -d "$INSTALL_DIR" ]; then
 echo "Removing application directory: $INSTALL_DIR"
 rm -rf "$INSTALL_DIR" || { echo "Failed to remove $INSTALL_DIR. Exiting..."; exit 1; }
else
 echo "Application directory not found: $INSTALL_DIR"
fi


# Remove the desktop entry
if [ -f "$DESKTOP_ENTRY" ]; then
 echo "Removing desktop entry: $DESKTOP_ENTRY"
 rm -f "$DESKTOP_ENTRY" || { echo "Failed to remove desktop entry. Exiting..."; exit 1; }
else
 echo "Desktop entry not found: $DESKTOP_ENTRY"
fi


# Update desktop database
echo "Updating desktop database..."
update-desktop-database || { echo "Failed to update desktop database. Exiting..."; exit 1; }


echo "$APP_NAME has been uninstalled successfully."

