OutFile "IncomeSetup.exe"


; Include Modern UI
!include "MUI2.nsh"


Name "Income & Tax Calculator"


; Define the directory for installer data
!define APP_DIST_PATH "dist"
!define MAIN_EXECUTABLE "income-win_x64.exe"
InstallDir "$LOCALAPPDATA\Income"
InstallDirRegKey HKCU "Software\income" "InstallPath"
RequestExecutionLevel user
!define MUI_ICON "resources\icons\income.ico"
!define MUI_UNICON "resources\icons\income.ico"


; Add installation pages
!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH


!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_LANGUAGE "English"


Section "Install"
   SetOutPath "$INSTDIR"
  
   ; Copy all files from distribution folder
   File /r "${APP_DIST_PATH}\*.*"
  
   ; Create shortcuts
   CreateDirectory "$SMPROGRAMS\income"
   CreateShortcut "$SMPROGRAMS\income\income.lnk" "$INSTDIR\income.exe" "" "$INSTDIR\resources\icons\income.ico"
   CreateShortcut "$DESKTOP\Budget Planner.lnk" "$INSTDIR\incomee.exe" "" "$INSTDIR\resources\icons\income.ico"
  
   ; Create uninstaller
   WriteUninstaller "$INSTDIR\Uninstall.exe"
  
   ; Registry entries (only HKCU)
   WriteRegStr HKCU "Software\income" "InstallPath" "$INSTDIR"
   WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\income" "DisplayName" "Income & Tax Calculator"

   WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\income" "UninstallString" "$INSTDIR\Uninstall.exe"
   WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\income" "DisplayIcon" "$INSTDIR\resources\icons\income.ico"
SectionEnd


Section "Uninstall"
   Delete "$INSTDIR\income.exe"
   Delete "$INSTDIR\*.dll"
   RMDir /r "$INSTDIR\resources"
   Delete "$INSTDIR\*.*"
   Delete "$INSTDIR\Uninstall.exe"
   RMDir "$INSTDIR"
  
   Delete "$SMPROGRAMS\income\income.lnk"
   RMDir "$SMPROGRAMS\income"
   Delete "$DESKTOP\income.lnk"
  
   DeleteRegKey HKCU "Software\income"
   DeleteRegKey HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\income"
SectionEnd
