!include "MUI2.nsh"

Name "Project Management Tool"
OutFile "project.exe"
!define APP_DIST_PATH "dist"
InstallDir "$LOCALAPPDATA\Project"
RequestExecutionLevel user

!define MUI_ICON "resources\icons\project.ico"
!define MUI_UNICON "resources\icons\project.ico"

!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_LANGUAGE "English"

Section "Install"
    SetOutPath "$INSTDIR"
    File /r "${APP_DIST_PATH}\*.*"
    
    # Rename the executable
    Rename "$INSTDIR\project-win_x64.exe" "$INSTDIR\project.exe"
    
    CreateDirectory "$SMPROGRAMS\Project Management Tool"
    CreateShortCut "$SMPROGRAMS\Project Management Tool\Project Management Tool.lnk" "$INSTDIR\project.exe"
    CreateShortCut "$DESKTOP\Project Management Tool.lnk" "$INSTDIR\project.exe"
    
    WriteUninstaller "$INSTDIR\Uninstall.exe"
    
    WriteRegStr HKCU "Software\ProjectManagementTool" "InstallPath" "$INSTDIR"
    WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\ProjectManagementTool" "DisplayName" "Project Management Tool"
    WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\ProjectManagementTool" "UninstallString" "$INSTDIR\Uninstall.exe"
    WriteRegStr HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\ProjectManagementTool" "DisplayIcon" "$INSTDIR\project.exe"
SectionEnd

Section "Uninstall"
    Delete "$INSTDIR\project.exe"
    Delete "$INSTDIR\*.dll"
    RMDir /r "$INSTDIR\resources"
    Delete "$INSTDIR\*.*"
    Delete "$INSTDIR\Uninstall.exe"
    RMDir "$INSTDIR"
    
    Delete "$SMPROGRAMS\Project Management Tool\Project Management Tool.lnk"
    RMDir "$SMPROGRAMS\Project Management Tool"
    Delete "$DESKTOP\Project Management Tool.lnk"
    
    DeleteRegKey HKCU "Software\ProjectManagementTool"
    DeleteRegKey HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\ProjectManagementTool"
SectionEnd